//////////////////////////////////////
//                                  //
//           RealPlayer.js          // 
//                                  //
//////////////////////////////////////
//
//               INSTRUCTIONS
//
// Use this file in your HTML documents by 
// including it in the head section
// of your document:
//
//   <script src="layers.js"></script>
//
// Then you can make calls to the functions
// described below to manipulate and query
// any named instance of a RealPlayer
// audio or video embed.
//
// For example, if you have a RealPlayer embed
// called "AudioClip", you can change its
// source with the RP_setSource() method:
//
//   RP_setSource("AudioClip","audio/a1t2p3b.rpm");
//
// You could then play the clip with the 
// RP_play() method:
//
//   RP_play("AudioClip");
//
// It is also possible to have multiple embeds
// that have unique names, and you can manage
// all of them with the G2 functions - just
// specify the embed name when making the
// function call.
//
// You will also notice that each function
// takes an optional document object as its
// last parameter.  This gives you the ability
// to control RealPlayer embeds in a different
// frame, or even a different window all together.
// All you have to do is build a reference to
// the document which contains the embed bearing
// the name supplied in the function call.
// For example, if there was an embed named "VideoClip"
// in a frame called "VideoFrame" which resides in
// the same frameset as the current document, you could
// stop it, change it's source, then play it
// with the following calls:
//
//   RP_stop("VideoClip",parent.VideoFrame);
//   RP_setSource("VideoClip","video/v1t2p3b.rpm",parent.VideoFrame);
//   RP_play("VideoClip",parent.VideoFrame);
//
///////////////////////////////////////////////////////
//                                                   //
//         JavaScript RealPlayer Functions           // 
//                                                   //
///////////////////////////////////////////////////////
// object RP_getClipRef(clipName[, doc])             //
// int RP_getPlayState(clipName[, doc])              //
// int RP_getPosition(clipName[, doc])               //
// void RP_setPosition(clipName, pos[, doc])         //
// void RP_setSource(clipName, sourceString[,  doc]) //
// void RP_setSourcePlay(clipName, sourceString[, doc])//	
// string RP_getSource(clipName[, doc])              //
// int RP_getLength(clipName[, doc])                 //
// void RP_stop(clipName[, doc])                     //
// void RP_play(clipName[, doc])                     //
// void RP_pause(clipName[, doc])                    //
// void RP_setVolume(clipName, vol[, doc])           //
// int RP_getVolume(clipName[, doc])                 //
///////////////////////////////////////////////////////
//                                           //
//      RealPlayer Play State Constants      //
///////////////////////////////////////////////
var RP_STOPPED    = 0;
var RP_CONTACTING = 1;
var RP_BUFFERING  = 2;
var RP_PLAYING    = 3;
var RP_PAUSED     = 4;
var RP_SEEKING    = 5;

var RP_debug = true;

var RP_recCount = 0;

var RP_inNetscape45 = (navigator.appName == 'Netscape' && parseInt(navigator.appVersion) < 5);
var RP_inIe4 = (navigator.appName == "Microsoft Internet Explorer" && parseInt(navigator.appVersion) >= 4);
var RP_inNetscape6 = (navigator.appName == 'Netscape' && parseInt(navigator.appVersion) >= 5);
var RP_unsupportedBrowser = (!(RP_inNetscape45 || RP_inIe4 || RP_inNetscape6));

function RP_checkClipRef(clipRef, functionName, doc)
{
	if (RP_checkClipRef.arguments.length < 3)
	{
		doc = document;
	}

	if ( typeof(clipRef) == 'string' )
	{
		return RP_getClipRef(clipRef, doc);
	}
	else
	{
		if ( typeof(clipRef) != 'object')
		{
			if (RP_debug)
				alert("Invalid argument to RP_checkClipRef():\n"+functionName+" clipRef needs to be a string or a clip reference.");
			return null;
		}
	}
	return clipRef;
}

function RP_getClipRef(clipName, doc)
{
	RP_recCount = 0;
	if (RP_getClipRef.arguments.length < 2)
	{
		doc = document;
	}
	
	return RP_getClipRef2(clipName, doc);
}

function RP_getClipRef2(clipName, doc)
{
	var clipRef = null;	
	
	// Base Case 1
	if (navigator.appName == "Microsoft Internet Explorer") 
	{
		clipRef = eval("doc." + clipName);
		return clipRef;
	}

	// Base Case 2
	if (RP_recCount++ >= 100) 
	{
		return null;
	}	

	// Base Case 3
	if (doc.embeds.length > 0) // look for embed in the document	
	{
		if (doc.embeds[clipName] != null) 
		{
			clipRef = doc.embeds[clipName];
			return clipRef;
		}			
	}	

	if (RP_inNetscape6)
	{
		return doc.getElementById(clipName);
	}
	else
	{	
		// Possible Recursion	
		for (var i=0;i<doc.layers.length;i++) // for each layer in the document
		{
			//alert("You have found layer: " + doc.layers[i].id);
			if (doc.layers[i].document.embeds.length > 0)
			{
				if (doc.layers[i].document.embeds[clipName] != null) 
				{
					clipRef = doc.layers[i].document.embeds[clipName];
					return clipRef;
				}
			}
			if (doc.layers[i].document.layers.length > 0) 
				if ( (clipRef = RP_getClipRef2(clipName,doc.layers[i].document)) != null ) 
					break;
		}
	}
	
	return clipRef;
}


function RP_getPlayState(clipName, doc)	
{
	if (RP_getPlayState.arguments.length < 2)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_getPlayState()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_getPlayState():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return RP_STOPPED;
	}
	else
	{
		if (eval('typeof(clipRef.GetPlayState) == "undefined"'))
		{
			return RP_STOPPED;
		}
		return clipRef.GetPlayState();
	}
}

function RP_getPosition(clipName, doc)	
{
	if (RP_getPosition.arguments.length < 2)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_getPosition()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_getPosition():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return 0;
	}
	else
	{
		return clipRef.GetPosition();
	}
}

function RP_setPosition(clipName, pos, doc)	
{
	if (RP_setPosition.arguments.length < 3)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_setPosition()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_setPosition():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	else
	{
		return clipRef.SetPosition(pos);
	}
}

function RP_setSource(clipName, sourceString, doc)	
{
	if (RP_setSource.arguments.length < 3)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_setSource()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_setSource():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	else
	{
		clipRef.SetSource(sourceString);
	}
}

function RP_setSourcePlay(clipName, sourceString, doc)	
{
	if (RP_setSourcePlay.arguments.length < 3)
	{
		doc = document;
	}		
	var clipRef = RP_checkClipRef(clipName, "RP_setSourcePlay()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_setSourcePlay():\n\nThe Windows Media embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	else
	{
		clipRef.SetSource(sourceString);
		RP_play(clipName, doc);
	}
}

function RP_getSource(clipName, doc)	
{
	if (RP_getSource.arguments.length < 2)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_getSource()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_getSource():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return null;
	}
	else
	{
		return RP_cleanupURL(clipRef.GetSource());
	}
}

function RP_getLength(clipName, doc)	
{
	if (RP_getLength.arguments.length < 2)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_getLength()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_getLength():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return null;
	}
	else
	{
		return clipRef.GetLength();
	}
}

function RP_cleanupURL(url)
{
	url = url + "";
	for (var i=0;i<url.length;i++)
	{
		if (url.charCodeAt(i) < 32 || url.charCodeAt(i) > 126)
		{
			url = url.slice(0,i) + url.slice(i+1,url.length);
		} 
		else if (url.charAt(i) == "\\")
		{
			url = url.slice(0,i) + "/" + url.slice(i+1,url.length);
		}
	}
	return url;
}

function RP_stop(clipName, doc)	
{
	if (RP_stop.arguments.length < 2)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_stop()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_stop():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	else
	{
		clipRef.DoStop();
	}
}	

function RP_play(clipName, doc)
{
	if (RP_play.arguments.length < 2)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_play()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_play():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	else
	{
		clipRef.DoPlay();
	}
}

function RP_pause(clipName, doc)
{
	if (RP_pause.arguments.length < 2)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_pause()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_pause():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	else
	{
		clipRef.DoPause();
	}
}

function RP_getVolume(clipName, doc)	
{
	if (RP_getVolume.arguments.length < 2)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_getVolume()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_getVolume():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return 0;
	}
	else
	{
		return clipRef.GetVolume();
	}
}

function RP_setVolume(clipName, vol, doc)	
{
	if (RP_setVolume.arguments.length < 3)
	{
		doc = document;
	}		

	var clipRef = RP_checkClipRef(clipName, "RP_setVolume()", doc);		

	if (clipRef == null)
	{
		if (RP_debug)
			alert("In call to RP_setVolume():\n\nThe RealPlayer embed, " + clipName + ", could not be found in document, " + doc.location + ".");
		return;
	}
	else
	{
		return clipRef.SetVolume(vol);
	}
}

